using UnityEngine;
using System.Collections;
using System.Collections.Generic;
using Verse;
using RimWorld;



namespace Verse.AI{
public class JobDriver_AttackStatic : JobDriver
{	
	//Working vars
	bool startedIncapacitated = false;

	public override void ExposeData()
	{
		base.ExposeData();
		Scribe_Values.LookValue(ref startedIncapacitated, "startedIncapacitated");
	}

	protected override IEnumerable<Toil> MakeNewToils()
	{
		yield return Toils_Misc.ThrowColonistAttackingMote(TargetIndex.A);

		Toil init = new Toil();
		init.initAction = ()=>
		{
			Pawn targetPawn = TargetThingA as Pawn;
			if( targetPawn != null )
				startedIncapacitated = targetPawn.Downed;

			pawn.pather.StopDead();
		};
		init.tickAction = ()=>
		{
			//End job in success if:
			//  target destroyed
			//  pawn target is incapped (where he wasn't when the job was initiated)
			if (TargetA.HasThing)
			{
				Pawn targetPawn = TargetA.Thing as Pawn;
				if (TargetA.Thing.Destroyed
					|| (targetPawn != null && !startedIncapacitated && targetPawn.Downed))
				{
					EndJobWith(JobCondition.Succeeded);
					return;
				}
			}

			pawn.equipment.TryStartAttack(TargetA);
		};
		init.defaultCompleteMode = ToilCompleteMode.Never;
		yield return init;
	}
}}